<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\Banner\StoreRequest;
use App\Http\Requests\Banner\EditRequest;
use App\Traits\FileUploadTrait;
use Illuminate\Support\Facades\File;

class BannerController extends Controller
{
    use FileUploadTrait;
    public function __construct()
    {
        $this->model="App\Models\Banner";
        $this->consultant="App\Models\Consultant";
        $this->section="App\Models\Section";
    }

    public function index(){
        $banners=$this->model::with('userInfo:id,name','section:id,name')->get();
        // $consultants = $this->consultant::consultant()->get();
        // $sections = $this->section::get();
        return view('admin.banner.index',compact('banners'));
    }

    public function create (){
        $consultants = $this->consultant::consultant()->get();
        $sections = $this->section::get();
        return view('admin.banner.add',compact('consultants','sections'));
    }
    
    public function store(StoreRequest $request){
        $data=$request->validated();
        $data['cover'] = $this->uploadFile($request->cover, 'sections');     
        $this->model::create($data);
        return redirect(route('banner.index'))->with('success',trans('lang.created'));
    }

    public function update(EditRequest $request){
        $data=$request->validated();
        $banner= $this->model::find($request->id);

        if($request->hasFile('cover')) {
            
            if($banner->cover)
            {
                $img =public_path($banner->cover);
                File::delete($img);
            }
           
            
            $data['cover']=$this->uploadFile($request->cover, 'sections');     

        }
        $banner->update($data);
        
        return back()->with('success',trans('lang.updated'));
    }
    
    public function destroy(Request $request){
        $banner= $this->model::find($request->id);
        if($banner->cover)
        {
            $img =public_path($banner->cover);
            File::delete($img);
        }
        $banner->delete();
        return back()->with('success',trans('lang.deleted'));
    }

}
