<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AddConsultantRequest;
use App\Http\Requests\Admin\EditConsultantRequest;

class ConsultantsController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\User";
        $this->Section="App\Models\Section";
        $this->Country="App\Models\Country";
    }

    public function index(){
        $consultants=$this->model::consultant()->with('sections','country')->get();
        return view('admin.consultants.index',compact('consultants'));
    }

    public function create(){
        $sections=$this->Section::all();
        $countries=$this->Country::all();
        return view('admin.consultants.add',compact('sections','countries'));
    }

    public function store(AddConsultantRequest $request){
        $data=$request->validated();
        $data['role']="2";
        $data['image']=substr($request->image->store('public/profiles'), 7);
        $data['cover']=substr($request->cover->store('public/profiles'), 7);
        $user=$this->model::create($data);
        $sectionIds = $request->sections;
        $user->sections()->sync($sectionIds);
        return redirect(route('consultants.index'))->with('success',trans('lang.created'));
    }

    public function edit($id){
        $consultant=$this->model::whereId($id)->with('sections')->first();
        $consultantSections=$consultant->sections->pluck('pivot.section_id');
        $sections=$this->Section::all();
        $countries=$this->Country::all();
        return view('admin.consultants.edit',compact('consultant','sections','consultantSections','countries'));
    }

    public function update(EditConsultantRequest $request,$id){
        $data=$request->validated();

        if($request->hasFile('image'))
            $data['image']=substr($request->image->store('public/profiles'), 7);
        
        if($request->hasFile('cover'))
            $data['cover']=substr($request->cover->store('public/profiles'), 7);
        
        $consultant=$this->model::find($id);
        $consultant->update($data);
        $consultant->sections()->detach();
        $consultant->sections()->sync($request->sections);
        return redirect(route('consultants.index'))->with('success',trans('lang.updated'));
    }
    
    public function destroy(Request $request){
        $client=$this->model::destroy($request->id);
        return back()->with('success','تم الحذف بنجاح');
        
     }

}
