<?php

namespace App\Http\Controllers\Admin;

use App\Models\Discount;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AddDiscountRequest;

class DiscountsController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Discount";
    }

    public  function index(){
        $discounts=$this->model::orderByDESC('id')->get();
        return view('admin.discounts.index',compact('discounts'));
    }

    public function create(){
        return view('admin.discounts.add');
    }

    public function store(AddDiscountRequest $request){
        $data=$request->validated();
        $this->model::create($data);
        return  to_route('discounts.index')->with('success',trans('lang.created'));
    }

    public function changeActive($id){
        $discount=$this->model::find($id);
        $active=!$discount->active;
        $discount->update(['active' => $active]);
        return back()->with('success',trans('lang.updated'));
    }
}
