<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\EditPackageRequest;
use App\Http\Requests\Admin\StorePackageRequest;
use App\Http\Requests\Admin\EditPackageDetailsRequest;
use App\Http\Requests\Admin\StorePackageDetailsRequest;

class PackageController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Package";
        $this->Payment="App\Models\Payment";
        $this->PackageCountry="App\Models\PackageCountry";
        $this->Country="App\Models\Country";
        $this->Subscription="App\Models\Subscription";
    }

    public function index(){
        $packages=$this->model::get();
        return view('admin.packages.index',compact('packages'));
    }


    public function details($id){
        $packages=$this->PackageCountry::wherePackageId($id)
        ->with('country:id,name')->get();
        $countries= $this->Country::whereNotNull('name')->get(['id','name']);
        $pId=$id;
        return view('admin.packages.details',compact('packages','countries','pId'));
    }
    
    public function subscriptions(){
        $subscriptions=$this->Subscription::with('client','consultant')->orderByDESC('id')->get();
        return view('admin.packages.subscriptions',compact('subscriptions'));
    }
    
    public function subscriptions_packages(){
        $subscriptions=$this->Payment::with('client:id,name','package:id,name')->orderByDESC('id')->get();
        return view('admin.packages.subscriptions_packages',compact('subscriptions'));
    }

    public function store(StorePackageRequest $request){
        $data=$request->validated();
        if(!$data['points'])
            $data['points']=0;
        $package=$this->model::create($data);
        $package->update(['product_id' => "dreams_".$request->units."_".$package->id]);
        return back()->with('success',trans('lang.created'));
    }
    
    public function store_details(StorePackageDetailsRequest $request){
        $data=$request->validated();
        $temp =$this->PackageCountry::where(['country_id'=>$request->country_id,'package_id'=>$request->package_id])->first();
        if($temp){
            return back()->with('error','لقد تم اضافة سعر بالفعل للباقة في هذه الدولة');
        }
        $package=$this->PackageCountry::create($data);
        $package->update(['product_id' => "dreams_".$request->units."_".$package->id]);
        return back()->with('success',trans('lang.created'));
    }

    public function update_details(EditPackageDetailsRequest $request){
        $data=$request->validated();
        $package= $this->PackageCountry::find($request->id);
        $package->update($data);
        return back()->with('success',trans('lang.updated'));
    }
    
    public function update(EditPackageRequest $request){
        $data=$request->validated();
        if(!$data['points'])
            $data['points']=0;
        $package= $this->model::find($request->id);
        $package->update($data);
        return back()->with('success',trans('lang.updated'));
    }

    public function destroy(Request $request){
        $this->model::destroy($request->id);
        return  back()->with('success',trans('lang.deleted'));
    }
    
    public function destroy_details(Request $request){
        $this->PackageCountry::destroy($request->id);
        return  back()->with('success',trans('lang.deleted'));
    }
}
