<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\Sections\EditSectionRequest;
use App\Http\Requests\Sections\StoreSectionRequest;

class SectionsController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Section";
    }

    public function index(){
        $sections=$this->model::get();
        return view('admin.sections.index',compact('sections'));
    }

    public function store(StoreSectionRequest $request){
        $data=$request->validated();
        $data['image']=substr($request->image->store('public/sections'), 7);
        $data['order_number'] = $this->model::max('order_number') +1;
        $this->model::create($data);
        return back()->with('success',trans('lang.created'));
    }

    public function update(EditSectionRequest $request){
        $data=$request->validated();
        $section= $this->model::find($request->id);
        if($request->hasFile('image')){

            if(Storage::exists("public/".$section->image))
                Storage::delete("public/".$section->image);
            $data['image']=substr($request->image->store('public/sections'), 7);
        }
        $section->update($data);
        return back()->with('success',trans('lang.updated'));
    }

}
