<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Comment\StoreRequest;
use App\Http\Requests\Api\Comment\{GetRequest,CheckRequest};

class CommentController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\Comment";
        $this->post="App\Models\Info";
    }
    
    public function index(GetRequest $request){
        $comments=$this->model::where('post_id',$request->post_id)
        ->with('userInfo:id,name,image')
        ->get();
        return $this->success($comments);
    }
    
    public function store(StoreRequest $request){
        $data=$request->validated();
        $data['user_id'] =auth()->id();
        $this->post::whereId($request->post_id)->increment('comments_number');
        $comment=$this->model::create($data);
        $comment->load('userInfo:id,name,image');
        return $this->success($comment);
    }
    
    public function destroy(CheckRequest $request){
        $this->model::destroy($request->id);
        return $this->success(trans('lang.deleted'));    
    }


}
