<?php

namespace App\Http\Controllers\Api\Consultants;

use App\Http\Controllers\Controller;
use App\Traits\ResponsesTrait;
use Illuminate\Http\Request;

class ConsultationsController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model = "App\Models\Consultation";
        $this->Section = "App\Models\Section";
        $this->ConsultationDetails = "App\Models\ConsultationDetails";
    }

    public function index()
    {
        $consultations = $this->model::with('section:id,name','userInfo:id,name,image')->withCount('details')->whereConsultantId(auth()->id())->orderByDESC('id')->get();
        return $this->success($consultations);
    }

    public function endConsultation(Request $request)
    {
        $consultation=$this->model::find($request->id);
        $status=$consultation->status == 4 ? 2:4; 
        $this->model::whereId($request->id)->update(['status' => $status]);
        return $this->success("");
    }

}
