<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use Illuminate\Support\Facades\Validator;
class ConsultantsController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\User";
        $this->ConsultantResource="App\Http\Resources\ConsultantResource";
    }

    public function index(Request $request){
        $section_id=$request->section_id;
        $consultants=$this->model::consultant()->active()
        ->when($section_id, function ($query, $section_id) {
            return $query->whereHas('sections', function ($q) use ($section_id){
                $q->where('section_id',$section_id);
            });
        })->get();
        return $this->success( $this->ConsultantResource::collection($consultants));
    }

    public function show(Request $request){

        $rules =
        [
            'id' => 'required|exists:users,id',
        ];

        $messages = [];
        $valid = Validator::make(request()->all(), $rules, $messages);
        if ($valid->fails()) {
            return $this->failed($valid->messages()->first());
        }

        $consultant=$this->model::with('sections','consultations')->whereId($request->id)->first();
        $data=
        [
            'consultant' => $this->ConsultantResource::make($consultant),
            'description' => $consultant->description,
            'evaluation' =>  $consultant->consultations()->with('userInfo:id,name,image,cover')->where('is_published',2)->get()
        ];
        return $this->success($data);
    }

}
