<?php

namespace App\Http\Controllers\Api;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Info\StoreRequest;
use App\Http\Requests\Info\EditRequest;
use App\Traits\FileUploadTrait;
use Illuminate\Support\Facades\File;
use App\Traits\ResponsesTrait;
use App\Http\Requests\Api\Comment\GetRequest;
use DB;
class InfoController extends Controller
{
    use ResponsesTrait;
    use FileUploadTrait;
    public function __construct()
    {
        $this->model="App\Models\Info";
        $this->Comment="App\Models\Comment";
        $this->FavoritePosts="App\Models\FavoritePosts";
    }

    public function index(){
        $info=$this->model::get();
         return view('admin.info.index',compact('info'));
    }
    
    
    public function consultantPosts(){
        $info = $this->model::where('consultant_id',auth()->id())
        ->with('userInfo:id,name,image')
        ->select('id','cover','created_at','likes_number',
        'comments_number','views_number','consultant_id','title')
        ->get();
        
        return $this->success($info);
    }
    
    public function details(GetRequest $request){
        $info=$this->model::whereId($request->post_id);
        $info->increment('views_number');
        $info =$info->with('userInfo:id,name,image')
        ->first();
        $info->is_favorite=false;
        
        if(DB::table('favorite_posts')->where(['user_id'=>$request->user_id,'post_id'=>$request->post_id])->exists()){
            $info->is_favorite=true;
        }
        
        $comments=$this->Comment::where('post_id',$request->post_id)
        ->with('userInfo:id,name,image')
        ->get();
        return $this->success(['post_details'=>$info,'comments' => $comments]);
    }

    public function store(StoreRequest $request){
        $data=$request->validated();
        if(isset($_FILES['link'])) {
            $mime = $_FILES['link']['type'];
            if(strstr($mime, "video/")){
                $filetype = "video";
                $filetype = "image";
                $data['type']=2;
            }else if(strstr($mime, "image/")){
                $filetype = "image";
                $data['type']=1;
            }
        }
        $data['link']= $this->uploadFile($request->link, 'sections');     
        $data['cover']=  $this->uploadFile($request->cover, 'sections');  
        $data['consultant_id'] =auth()->id() ;
        $this->model::create($data);
        return $this->success(trans('lang.created'));
    }
    
    public function like(GetRequest $request){
        $post=$this->FavoritePosts::where(['user_id'=>auth()->id(),'post_id'=>$request->post_id])->first();
        if($post){
            $post->delete();
            $this->model::whereId($request->post_id)->decrement('likes_number');
            return $this->success(trans('lang.deleted'));
        }else{
            $this->FavoritePosts::create(['user_id' => auth()->id(),'post_id'=>$request->post_id]);
            $this->model::whereId($request->post_id)->increment('likes_number');
        }
        return $this->success(trans('lang.created'));
    }


}
