<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use  App\Http\Controllers\Api\StatisticsController;

class SectionsController extends Controller
{
    use ResponsesTrait;
    public function __construct(StatisticsController $statistics)
    {
        $this->model="App\Models\Section"; 
        $this->Banner="App\Models\Banner"; 
        $this->User="App\Models\User";
        $this->Info="App\Models\Info";
        $this->AboutUs="App\Models\AboutUs";
        $this->statistics=$statistics;
        $this->SectionResource="App\Http\Resources\SectionResource";
        $this->ConsultantResource="App\Http\Resources\ConsultantResource";
    }

    public function index(){
        $sections=$this->model::orderBy('order_number')->get();
        $statistics=$this->statistics->index();
        $consultants=$this->User::consultant()->online()->active()->with('sections')->get();
        //['id','name','image','consultation_price','response_rate','birth_date','consultations_number','rating_number']
       
        $slider = $this->Banner::get();
        $info = $this->Info::whereDate('start_date', '<=', date('Y-m-d'))
        ->whereDate('end_date', '>=', date('Y-m-d'))
        ->with('userInfo:id,name,image')
        ->select('id','cover','created_at','likes_number','comments_number'
        ,'views_number','consultant_id','title')
        ->get();
        $data=
        [
            "statistics" => $statistics,
            "sections" => $this->SectionResource::collection($sections),
            'consultants' => $this->ConsultantResource::collection($consultants),
            'slider' => $slider,
            'posts' => $info
        ];
        return $this->success($data);
    }

    public function sectionsList(){
        $sections=$this->model::get(['id','name','image']);
        return $this->success($sections);
    }

}
