<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class EditConsultantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return 
        [
            'name' => 'required|max:255',
            'password' => 'sometimes|nullable',
            'country_id' => 'sometimes|nullable',
            'phone' => 'required|unique:users,phone, '.$this->id,
            'response_rate' => 'required',
            'description' => 'required',
            'consultation_price' => 'required',
            'image' => 'sometimes|nullable',
            'cover' => 'sometimes|nullable',
            'birth_date' => 'required',
        ];
    }

    public function messages(): array {
        return [
            'phone.unique'  => 'The phone Is found.',
        ];
    }
}
