<?php

namespace App\Http\Requests\Banner;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'cover' => 'required',
            'consultant_id' => 'sometimes|nullable',
            'section_id' => 'sometimes|nullable',
            'url' => 'sometimes|nullable',
        ];
    }
    
    public function messages(): array {
        return [
            'title.required'  => 'The code is title',
            'cover.required'  => 'The code is cover',
        ];
    }

}
