<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    use HasFactory;
    protected $table="banners";
    protected $fillable = 
    [
      	'cover',	'url',	'consultant_id'	,'section_id'
    ];
    
    protected $hidden = 
    [
      	'created_at',	'updated_at'
    ];

    protected $casts = [
        'consultant_id' => 'string',
        'section_id' => 'string',
    ];
    public function userInfo()
    {
        return $this->hasOne(Consultant::class,'id','consultant_id');
    }
    
    public function section()
    {
        return $this->hasOne(Section::class,'id','section_id');
    }
}
