<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class Consultant extends Authenticatable
{
        use SoftDeletes;

    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table="users";
    protected $fillable = 
    [
        'name', 'image',
        'phone', 'birth_date',
        'social_status', 'password',
        'country_id','device_id',
        'role','job_status',
        'consultation_price','description',
        'response_rate','is_online',
        'rating_number','consultations_number',
        'gender' ,'cover' ,'unwatched_msg','active'
    ];

    protected $dates =[
        "birth_date"
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = 
    [
        // 'birth_date',
        'password',
        'remember_token',
        'device_id',
        'updated_at',
        'created_at',
        'email_verified_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = bcrypt($value);
    }

    // protected $appends = ['age'];

    public function getAgeAttribute()
    {
        return Carbon::parse($this->attributes['birth_date'])->age;
    }

    public function scopeConsultant($query)
    {
        return $query->where('role', 2);
    }

    public function scopeOnline($query)
    {
        return $query->where('is_online', true);
    }

    public function scopeClient($query)
    {
        return $query->where('role', 1);
    }

    public function country(){
        return $this->belongsTo(Country::class);
    }

    public function sections()
    {
        return $this->belongsToMany(Section::class, 'consultant_sections');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d');
    }
}
