<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Consultation extends Model
{
    use HasFactory;
    protected $fillable = [
        'title','user_id','section_id',
        'country_id','status','consultation_number',
        'consultant_id','description','rating_number',
        'job_status','social_status','is_published'
    ];

    protected $hidden = ['section_id','user_id' ,'country_id'];
    protected $dates = ['created_at'];


    public function details()
    {
        return $this->hasMany(ConsultationDetails::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i');
    }

    public function section()
    {
        return $this->belongsTo(Section::class);
    }


    public function consultantInfo()
    {
        return $this->hasOne(Consultant::class,'id','consultant_id');
    }

    public function userInfo()
    {
        return $this->hasOne(User::class,'id','user_id')->withDefault([
        'name' => 'عميل سابق',
        'image' =>"profiles/etaamn.jpg"
    ]);;
    }


}
