<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Info extends Model
{
    use HasFactory;
    protected $table="info";
    protected $fillable = 
    [
        'msg',	'type'	,'link','cover',
        'likes_number','comments_number',
        'views_number' , 'title','consultant_id',
        'start_date' ,'end_date'
    ];
    
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i');
    }
    
    public function userInfo()
    {
        return $this->hasOne(Consultant::class,'id','consultant_id');
    }
    
    protected $hidden = ['updated_at'];
}
