<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Section extends Model
{
    use HasFactory;
    protected $fillable = [
        'name','countries_number','image','order_number'
    ];

    protected $hidden = ['created_at', 'updated_at'];

    public function consultations()
    {
        return $this->hasMany(Consultation::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'consultant_sections');
    }

}
