<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

 class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('role')->default(1)->index();
            $table->integer('units')->default(0);
            $table->string('name');
            $table->string('email')->unique()->nullable();
            $table->string('phone')->unique();
            $table->unsignedBigInteger('country_id')->nullable()->index();
            $table->date('birth_date');
            $table->enum('social_status',["divorced","widower","single","married"])->default("single");
            $table->enum('job_status',["employed","unemployed"])->default("employed");
            $table->enum('gender',["male","female"])->nullable();
            $table->string('password');
            $table->string('image')->nullable();
            $table->string('device_id')->nullable();
            $table->integer('consultation_price')->default(0);
            $table->integer('response_rate')->default(1);
            $table->text('description')->nullable();
            $table->boolean('is_online')->default(false);
            $table->integer('rating_number')->default(0);
            $table->integer('consultations_number')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
