@extends('layouts.simple.master')
@section('title', 'Chat App')

@section('css')
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>تفاصيل الاستشارة</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">استشارات</li>
<li class="breadcrumb-item active">تفاصيل الاستشارة</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
        @php
            $client=$consultation->userInfo;
            $consultant=$consultation->consultantInfo;
        @endphp
		<div class="col call-chat-body">
			<div class="card">
				<div class="card-body p-0">
					<div class="row chat-box">
						<!-- Chat right side start-->
						<div class="col pe-0 chat-right-aside">
							<!-- chat start-->
							<div class="chat">
								<!-- chat-header start-->
								<div class="chat-header clearfix">
									<img class="rounded-circle" src="{{ asset('storage/'.$client->image) }}" alt="">
									<div class="about">
										<div class="name text-center">Client Name: {{ $client->name }}  </div>
										<div class="name">Client Title: {{ $consultation->title }}  </div>
										{{-- <div class="status">Last Seen 3:55 PM</div> --}}
									</div>
									{{-- <ul class="list-inline float-start float-sm-end chat-menu-icons">
										<li class="list-inline-item"><a href="#"><i class="icon-search"></i></a></li>
										<li class="list-inline-item"><a href="#"><i class="icon-clip"></i></a></li>
										<li class="list-inline-item"><a href="#"><i class="icon-headphone-alt"></i></a></li>
										<li class="list-inline-item"><a href="#"><i class="icon-video-camera"></i></a></li>
										<li class="list-inline-item toogle-bar"><a href="#"><i class="icon-menu"></i></a></li>
									</ul> --}}
								</div>
								<!-- chat-header end-->
								<div class="chat-history chat-msg-box custom-scrollbar">
									<ul>
                                    
                                        @foreach ($consultation->details as $msg )

                                            @if ($msg->user_type=="user")
                                               {{-- client --}}  
                                               <li>
                                                   @if ($msg->type=="text")
                                                        <div class="message my-message">
                                                            <img class="rounded-circle float-start chat-user-img img-30" src="{{ asset('storage/'.$client->image) }}" alt="">
                                                            <div class="message-data text-end"><span class="message-data-time">{{ $msg->created_at->format('g:i A')  }}</span></div>
                                                            {{ $msg->details }}
                                                        </div>
                                                   @elseif($msg->type=="file")
                                                   <a href="{{ asset('storage/'.$msg->details ) }}" download rel="noopener noreferrer" class ="m-2 p-2" target="_blank">Download File</a>
                                                   @else
                                                        <div class="message my-message">
                                                            <img class="rounded-circle float-start chat-user-img img-30" src="{{ asset('storage/'.$client->image) }}" alt="">
                                                            <div class="message-data text-end"><span class="message-data-time">{{ $msg->created_at->format('g:i A')  }}</span></div>
															<audio controls controlsList="nodownload" id="a1" preload="auto" autoplay  src="{{ asset('storage/'.$msg->details ) }}"></audio>
                                                        </div>

                                                   @endif
                                                   
                                                </li>
                                            @else
                                                {{-- consultant --}}

                                                @if ($msg->type=="text")
                                                    <li class="clearfix">
                                                        <div class="message other-message pull-right">
                                                            <img class="rounded-circle float-end chat-user-img img-30" src="{{ asset('storage/'.$consultant->image) }}" alt="">
                                                            <div class="message-data"><span class="message-data-time">{{ $msg->created_at->format('g:i A')  }}</span></div>
                                                            {{ $msg->details }}
                                                        </div>
                                                    </li>
                                                @else
                                                    <li class="clearfix">
                                                        <div class="message other-message pull-right">
                                                            <img class="rounded-circle float-end chat-user-img img-30" src="{{ asset('storage/'.$consultant->image) }}" alt="">
                                                            <div class="message-data"><span class="message-data-time">{{ $msg->created_at->format('g:i A')  }}</span></div>
															<audio controls controlsList="nodownload" id="a1" preload="auto" autoplay  src="{{ asset('storage/'.$msg->details ) }}"></audio>
                                                        </div>
                                                    </li>
                                                @endif
                                                
                                            @endif
                                            
                                        @endforeach

									</ul>
								</div>
								<!-- end chat-history-->
								{{-- <div class="chat-message clearfix">
									<div class="row">
										<div class="col-xl-12 d-flex">
											<div class="smiley-box bg-primary">
												<div class="picker"><img src="{{asset('assets/images/smiley.png')}}" alt=""></div>
											</div>
											<div class="input-group text-box">
												<input class="form-control input-txt-bx" id="message-to-send" type="text" name="message-to-send" placeholder="Type a message......">
												<button class="input-group-text btn btn-primary" type="button">SEND</button>
											</div>
										</div>
									</div>
								</div> --}}
								<!-- end chat-message-->
								<!-- chat end-->
								<!-- Chat right side ends-->
							</div>
						</div>
					
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/fullscreen.js')}}"></script>
@endsection