@extends('layouts.simple.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>اضافة معلومة</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">المعلومات</li>
<li class="breadcrumb-item active">اضافة  معلومة</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
			@if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
				<div class="card-body">
					<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('info.store') }}">
                        @csrf
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">العنوان</label>
								<input class="form-control" id="validationCustom01" type="text" name="title" value="{{ old('title') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							 <div class="col-md-6 mb-3">
                                <div class="col">
                                    <div class="mb-3 mb-0">
                                        <label for="exampleFormControlTextarea4">الوصف</label>
                                        <textarea class="form-control" id="exampleFormControlTextarea4" name="msg" rows="3" required>{{ old('msg') }}</textarea>
                                    </div>
                                </div>
                            </div>
				
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom03">الخبراء</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="consultant_id"  required="">
                                    @forelse ($consultants as $section)

                                        <option value="{{ $section->id }}">{{ $section->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid consultant.</div>

                            </div>

						


						</div>

						<div class="row">
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ البداية</label>
								<input class="form-control" id="validationCustom01" type="date" name="start_date" value="{{ old('start_date') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ النهاية</label>
								<input class="form-control" id="validationCustom01" type="date" name="end_date" value="{{ old('end_date') }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							
						</div>
						<div class="mb-3">
                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 row">
                                        <label class="col-sm-3 col-form-label">Upload media</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="file" name="link" value="{{ old('image') }}" required >
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-12 mb-3">
                                <div class="col">
                                    <div class="mb-3 row">
                                        <label class="col-sm-3 col-form-label">Upload Cover</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="file" name="cover" value="{{ old('image') }}" required accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div>
							

						</div>
						<button class="btn btn-primary" type="submit">حفظ</button>
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection