@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>التعليقات</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">التعليقات</li>
<li class="breadcrumb-item active">عرض التعليقات</li>
@endsection

@section('content')

<div class="container-fluid">
	<div class="row">

		<!-- Column rendering  Starts-->
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
					    	<table id="example" class="display" cellspacing="0" width="100%">
    <thead>
        <tr>
        	<th>#</th>
			<th>Section</th>
			<th>Consultant</th>
			<th>Client</th>
			<th>Start date</th>
			<th>Status</th>
			<th></th>
        </tr>
    </thead>
 
    <tfoot>
        <tr>
         	<th>#</th>
			<th>Section</th>
			<th>Consultant</th>
			<th>Client</th>
			<th>Start date</th>
			<th>Status</th>
			<th></th>
        </tr>
    </tfoot>
 
    <tbody>
        @foreach ($evaluations as $evaluation)
        <tr>
            <td>{{ $evaluation->consultation_number }}</td>
            <td>{{ $evaluation->section->name }}</td>
            <td>{{ $evaluation->consultantInfo->name?? " تم حذف هذا الخبير"}}</td>
            <td>{{ $evaluation->userInfo->name  ?? "تم حذف هذا العميل"}}</td>
            <td>{{ $evaluation->updated_at->format('Y-m-d') }}</td>
            <td>
                                            @for ($i = 0; $i < $evaluation->rating_number; $i++)
                                                <i class="fa fa-star text-warning"></i>
                                            @endfor
                                            @for ($i = 0; $i <5- $evaluation->rating_number; $i++)
                                                <i class="fa fa-star-o text-secondary"></i>
                                            @endfor
                                        </td>
            <td>
				<button class="btn btn-primary"  type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal" 
				onclick="getData({{ $evaluation }})">مراجعة</button>

                @if ($evaluation->is_published == 1)
                    <a href="{{ route('admin.evaluations.accept',$evaluation->id) }}">
                        <button class="btn btn-pill btn-success">موافقة</button>
                    </a>
                    <a href="{{ route('admin.evaluations.refuse',$evaluation->id) }}">
                        <button class="btn btn-pill btn-danger">رفض</button>
                    </a>
                @elseif($evaluation->is_published == 2)
                    <span class="badge badge-success">
                        accepted
                    </span>
                @elseif($evaluation->is_published == 3)
                    <span class="badge badge-danger">
                        refused
                    </span>
                @endif
				
			</td>
        </tr>
        @endforeach
       

    </tbody>
</table>
					</div>
				</div>
			</div>
		</div>
	
		
	
	
	
	</div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">مراجعة التقييم</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

				<div class="row">
					<div class="col-md-12 mb-3">
						<div class="mb-3 mb-0">
							<label for="exampleFormControlTextarea4">description</label>
							<textarea class="form-control" id="dess" ></textarea>
						</div>
					</div>
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					{{-- <button class="btn btn-secondary" type="submit">Save changes</button> --}}
				 </div>

		  </div>
		  
	   </div>
	</div>
 </div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>


	<script src="https://code.jquery.com/jquery-3.5.1.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#example').DataTable( {
			     "order": [[ 2, "desc" ]],
				initComplete: function () {
					this.api().columns([2]).every( function () {
						
						var column = this;
						var select = $("<select class='form-control p-2'><option value=''></option></select>")
							.appendTo( $(column.header()).empty() )
							.on( 'change', function () {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
		
								column
									.search( val ? '^'+val+'$' : '', true, false )
									.draw();
							} );
		
						column.data().unique().sort().each( function ( d, j ) {
							select.append( '<option value="'+d+'">'+d+'</option>' )
						} );
					} );
				}
			} );
		} );
	</script>
@endsection

<script>
	function getData(evaluation){
		if(evaluation){
			document.getElementById("dess").value=evaluation['description'];
		}
	}
</script>