@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/sweetalert2.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">


@endsection

@section('style')

@endsection

@section('breadcrumb-title')
<h3> الاشعارات </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">الاشعارات </li>
<li class="breadcrumb-item active">عرض الاشعارات</li>
@endsection

@section('content')
    <div class="container-fluid">

        <div class="row">
            <div class="d-flex justify-content-end col-sm-12">
                <button class="btn btn-primary"  type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal">Add</button>
            </div>
            <div class="col-sm-12 mt-3">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display" id="advance-1">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Body</th>
                                        <th>Type</th>
                                        <th>Consultant</th>
                                        <th></th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach ($notifications as  $notification)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $notification->title_ar  }}</td>
                                        <td>{{ $notification->body_ar }}</td>
                                        <td>
                                            @if ($notification->type == 1)
                                                <span class="badge badge-primary">
                                                    عام
                                                </span>
                                                
                                            @endif
                                        </td>
                                        <td>{{ $notification->consultant->name }}</td>
                                        <td>
                                            <form action="{{ route('admin.notifications.delete',$notification->id) }}" onclick="getId({{ $notification->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                    
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Body</th>
                                        <th>Type</th>
                                        <th>Consultant</th>
                                        <th></th>
                                
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        
        </div>

    </div>

    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">add Notification</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('admin.notifications.store') }}">
                    @csrf

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="section_name">Title</label>
                            <input class="form-control" id="section_name" type="text" name="title_ar" value="" placeholder="Title" required="">
                            <div class="valid-feedback">Looks good!</div>
                            <div class="invalid-feedback">Please choose a Title.</div>
    
                        </div>

                        <div class="col-md-12 mb-3">
                            <div class="col">
                                <div class="mb-3 mb-0">
                                    <label for="exampleFormControlTextarea4">Body</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea4" name="body_ar" rows="3" required></textarea>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-md-12 mb-3">
                            <label for="validationCustom03">Type</label>

                            <select class="form-control col-sm-12"  id="validationCustom03"  name="type" required >
                                <option value="1">general</option>
                            </select>
                            <div class="invalid-feedback">Please provide a valid Type.</div>

                        </div>


                        <div class="col-md-12 mb-3">
                            <label for="validationCustom04">Consultants</label>

                            <select class="form-control col-sm-12"  id="validationCustom04"  name="consultant_id" >
                                <option value=""></option>
                                @forelse ($consultants as $consultant)
                                    <option value="{{ $consultant->id }}">{{ $consultant->name }}</option>
                                @empty
                                    
                                @endforelse
                          
                            </select>
                            <div class="invalid-feedback">Please provide a valid consultant.</div>

                        </div>

                    </div>
                        
                        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
                        <button class="btn btn-secondary" type="submit">Save changes</button>
                    </div>
                </form>

            </div>
            
        </div>
        </div>
    </div>

@endsection

@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>

<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>
	function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>