@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/sweetalert2.css')}}">


@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> الباقات </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">الباقات</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		<div class="d-flex justify-content-end col-sm-12">
			<button class="btn btn-primary"  type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal">اضافة باقة</button>
		</div>
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display"  id="advance-1">
							<thead>
								<tr class="text-center">
									<th>باقة</th>
									<th>عدد الوحدات</th>
									<th>points </th>
									<th>السعر الافتراضي</th>
									<th>knet </th>
									<th>التاريخ</th>
									<th></th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($packages as $package)
									<tr class="text-center">
										<td>{{ $package->name }}</td>
										<td>{{ $package->units }}</td>
										<td>{{ $package->points }}</td>
										<td>{{ $package->price }}</td>
										<td>{{ $package->knet }}</td>
										<td>{{ $package->created_at->format('Y-m-d') }}</td>
																				
										<td>

                                            <a href="{{ route('admin.packages.details',$package->id) }}">
												<button class="btn btn-pill btn-primary">تفاصيل</button>
											</a>
											<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $package }})">تعديل</button>
                                            <form action="{{ route('admin.package.delete') }}" onclick="getId({{ $package->id }})" method="get" id="form_id">
                                                @csrf
                                                <input type="hidden" name="id" id="packagee_id">
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >حذف</button>
                                            </form>
										</td>
							
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
							<tr class="text-center">
									<th>باقة</th>
									<th>عدد الوحدات</th>
									<th>points </th>
									<th>السعر الافتراضي</th>
									<th>knet </th>
									<th>التاريخ</th>
									<th></th>
									
								</tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">تعديل الباقة</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">
            <form class="needs-validation" novalidate="" method="POST"  action="{{ route('admin.package.edit') }}">
				@csrf
                <input type="hidden" name="id" id="package_id">
				<div class="row">
					<div class="col-md-6 mb-3">
						<label for="section_name">باقة</label>
						<input class="form-control" id="p_name" type="text" name="name" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">عدد الوحدات</label>
						<input class="form-control" id="units" type="number" name="units" value="" placeholder="units" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a units.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">السعر الافتراضي</label>
						<input class="form-control" id="price" type="number" name="price" value="" placeholder="price" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a price.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">knet </label>
						<input class="form-control" id="knet" type="number" name="knet" value="" placeholder="knet" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a knet.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">points </label>
						<input class="form-control" id="points" type="number" name="points" value="" placeholder="points">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a knet.</div>
					</div>
				
				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">الغاء</button>
					<button class="btn btn-secondary" type="submit">تعديل</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">اضافة باقة</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST"  action="{{ route('admin.package.store') }}">
				@csrf
				<div class="row">
					<div class="col-md-6 mb-3">
						<label for="section_name">باقة</label>
						<input class="form-control" id="" type="text" name="name" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">عدد الوحدات</label>
						<input class="form-control" id="section_name" type="number" name="units" value="" placeholder="units" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a units.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">السعر الافتراضي</label>
						<input class="form-control" id="section_name" type="number" name="price" value="" placeholder="price" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a price.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">knet </label>
						<input class="form-control" id="section_name" type="number" name="knet" value="" placeholder="knet" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a knet.</div>
					</div>
						<div class="col-md-6 mb-3">
						<label for="section_name">points </label>
						<input class="form-control" id="" type="number" name="points" value="" placeholder="points">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a knet.</div>
					</div>
				
				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">الغاء</button>
					<button class="btn btn-secondary" type="submit">حفظ</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>


@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>

	function getRecord(data){
	    document.getElementById("points").value=data['points'];
	    document.getElementById("knet").value=data['knet'];
	    document.getElementById("price").value=data['price'];
	    document.getElementById("p_name").value=data['name'];
	    document.getElementById("units").value=data['units'];
	    document.getElementById("package_id").value=data['id'];
   }

   function getId(id){
	    document.getElementById("packagee_id").value=id;
   }
</script>