@extends('layouts.simple.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/sweetalert2.css')}}">


@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> مدفوعات الخبراء </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">لوحة التحكم</li>
<li class="breadcrumb-item active">مدفوعات الخبراء</li>
@endsection

@section('content')
<div class="container-fluid">

	<div class="row">
		<div class="d-flex justify-content-end col-sm-12">
			<button class="btn btn-primary"  type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal">Add</button>
		</div>
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display"  id="advance-1">
							<thead>
								<tr class="text-center">
									<th>Client</th>
									<th>Consultant</th>
									<th>Price</th>
									<th>Discount</th>
									<th>Date</th>
									
								</tr>
							</thead>
							<tbody>
								@forelse ($subscriptions as $subscription)
									<tr class="text-center">
										<td>{{ $subscription->client->name ?? "تم حذف هذا العميل" }}</td>
										<td>{{ $subscription->consultant->name ?? " تم حذف هذا الخبير" }}</td>
										<td>{{ $subscription->value }}</td>
										<td>
                                            @if ($subscription->discount_id)
                                                <span class="badge badge-success">
                                                    بخصم
                                                </span>
                                            @else
                                                <span class="badge badge-primary">
                                                    بدون خصم
                                                </span>
                                            @endif
                                        </td>
										<td>{{ $subscription->created_at->format('Y-m-d') }}</td>
																			
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr class="text-center">
                                    <th>Client</th>
									<th>Consultant</th>
									<th>Price</th>
									<th>Discount</th>
									<th>Date</th>
                                </tr>
							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Edit Package</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">
            <form class="needs-validation" novalidate="" method="POST"  action="{{ route('admin.package.edit') }}">
				@csrf
                <input type="hidden" name="id" id="package_id">
				<div class="row">
					<div class="col-md-6 mb-3">
						<label for="section_name">units</label>
						<input class="form-control" id="units" type="number" name="units" value="" placeholder="units" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a units.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">Price</label>
						<input class="form-control" id="price" type="number" name="price" value="" placeholder="price" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a price.</div>
					</div>
				
				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">Add Package</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST"  action="{{ route('admin.package.store') }}">
				@csrf
				<div class="row">
					<div class="col-md-6 mb-3">
						<label for="section_name">units</label>
						<input class="form-control" id="section_name" type="number" name="units" value="" placeholder="units" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a units.</div>
					</div>
					<div class="col-md-6 mb-3">
						<label for="section_name">Price</label>
						<input class="form-control" id="section_name" type="number" name="price" value="" placeholder="price" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a price.</div>
					</div>
				
				</div>
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
					<button class="btn btn-secondary" type="submit">Save changes</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>


@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>

	function getRecord(data){
	    document.getElementById("price").value=data['price'];
	    document.getElementById("units").value=data['units'];
	    document.getElementById("package_id").value=data['id'];
   }

   function getId(id){
	    document.getElementById("package_id").value=id;
   }
</script>