<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
class ProductController extends Controller
{
    public function index(){
        $this->lang();
        $products=Product::with('images:id,product_id,name','seller:id,name',"category:id,$this->name")
        ->select('id',$this->name,$this->description,"price","quantity",'main_image','seller_id','category_id','is_available')
        ->get();
        return view('admin.product.index',compact('products'));
    }

    public function update($id){
        #TODO complete
        $product =Product::find($id);
        $status= $product->is_available == 0?1:0;
        $product->update(['is_available' => $status]);
        return to_route('product.index')->with('success',trans('lang.updated'));
    }

}
