<?php

namespace App\Http\Controllers\Client;

use App\Models\Product;
use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Models\FavouriteProduct;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\City\CheckRequest;

class FavouriteProductController extends Controller
{
    use ResponsesTrait;

    public function index(){
        $this->lang();
        $products = Product::join('favourite_products','product_id','products.id')
        ->where([['is_available',1],['quantity','>',0]])
        ->select('favourite_products.id as favourite_id','products.id' ,$this->name ,$this->description,'price','quantity','main_image')
        ->get();
        return $this->success($products);
    }

    public function store(CheckRequest $request){
        FavouriteProduct::create(['user_id'=> auth()->id(), 'product_id'=> $request->id]);
        return $this->success(null,trans('lang.created'));
    }
    
    public function delete(Request $request){
        FavouriteProduct::destroy($request->favourite_id);
        return $this->success(null,trans('lang.deleted'));
    }
}
