@extends('seller.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.Orders') </h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active">@lang('lang.Orders')</li>
@endsection
@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th>@lang('lang.Order_Number')</th>
									<th class="text-center">@lang('lang.Total_Price')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.Client')</th>
									<th class="text-center">@lang('lang.Time')</th>
									<th class="text-center">@lang('lang.delivery_time')</th>
									<th></th>								
								</tr>
							</thead>
							<tbody>
								@forelse ($orders as $order)
									<tr>
										<td>{{ $order->order_number }}</td>
										<td class="text-center">{{ $order->total_price}}</td>
										<td>{{ $order->status}}</td>
										<td>
											{{ 
												$order->user->name
											}}
										</td>
										<td class="text-center">{{ $order->created_at->format('Y-m-d - H:i') }}</td>
										<td class="text-center">{{ $order->delivery_time->format('Y-m-d - H:i') }}</td>
										<td>
											<a href="{{ route('seller.order.details',$order->id) }}" class="btn btn-primary" >@lang('lang.details')</a>
											@if($order->file)
    											<a href="{{asset($order->file)}}" download rel="noopener noreferrer" target="_blank" class="btn btn-success">
                                                   @lang('lang.downloadFile')
                                                </a>
                                            @endif
											
										</td>
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.Order_Number')</th>
									<th class="text-center">@lang('lang.Total_Price')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.Client')</th>
									<th class="text-center">@lang('lang.Time')</th>
									<th class="text-center">@lang('lang.delivery_time')</th>
									<th></th>								
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection
	
@section('script')

<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
@endsection