<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CarModel\EditRequest;
use App\Http\Requests\Admin\CarModel\StoreRequest;
use App\Models\CarModel;

class CarModelController extends Controller
{
    public function index()
    {
        $result = CarModel::get();
        $pageName="";
        return view("admin.carModel.index",compact('result','pageName'));
    }

    public function store(StoreRequest $request)
    {
        CarModel::create($request->validated());
        return back()->with('success',trans('lang.created')); 
    }
 
    public function update(EditRequest $request)
    {
        CarModel::whereId($request->id)->update($request->validated());
        return back()->with('success',trans('lang.updated')); 
    }


    public function destroy($id)
    {
        //
    }
}
