<?php

namespace App\Http\Requests\Client\Ride;

use App\Traits\ResponsesTrait;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
class ContactRideRequest extends FormRequest
{
    use ResponsesTrait;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    protected $stopOnFirstFailure = true;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
  public function rules()
    {
        return [
            'ride_id' => 'required',
            'name' => 'required',
            'type' => ['required', 'in:text,image'],        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));
    }

    public function messages(): array {
        return [
            'ride_id.required'  => 'The ride_id Is required.',
            'name.required'  => 'The name Is required.',
            'type.required'  => 'The type must Is  required.'
        ];
    }
}
