<?php

namespace App\Http\Controllers\Admin;

use App\Models\{City,UserAdress,User};
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\City\EditRequest;
use App\Http\Requests\Admin\City\StoreRequest;
use DB;

class CityController extends Controller
{
    public function index(){
        $this->lang();
        $cities = City::with("parent:id,$this->locale")->get(['id','parent_id','name_ar','name_en']);
        return view('admin.city.index',compact('cities'));
    }

    public function create(){
        $this->lang();
        $cities=City::whereNull('parent_id')->select('id',"$this->locale")->get();
        return view('admin.city.add',compact('cities'));  
    }

    public function store(StoreRequest $request){
        City::create($request->validated());
        return  to_route('city.index')->with('success',trans('lang.created')); 
    }

    public function update(EditRequest $request){
        $city=City::find($request->id);
        $city->update($request->validated());
        return  to_route('city.index')->with('success',trans('lang.updated')); 
    }
    
    public function destroy(Request $request){

        $city=User::where('city_id',$request->id)->first();
        if($city){
            return back()->withErrors(['city' => "لا يمكنك حذف المنطقة لان هناك بيانات  متعلقة بها"]);
        }
        else 
        {
            if(City::where('parent_id',$request->id)->first()){
            return back()->withErrors(['city' => "لا يمكنك حذف المنطقة لان هناك بيانات  متعلق}ة بها"]);
        
            }
            }
        City::destroy($request->id);
        return  to_route('city.index')->with('success',trans('lang.deleted')); 
    }

}
