<?php

namespace App\Http\Controllers\Driver;

use App\Models\CarType;
use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Repositories\CrudRespositoryInterface;

class CarTypeController extends Controller
{
    use ResponsesTrait;
    private $carTypeRepository;
    public function __construct(CrudRespositoryInterface $carTypeRepository)
    {
        $this->carTypeRepository = $carTypeRepository;  
    }
    
    public function index()
    { 
        $this->lang();
        return $this->success($this->carTypeRepository->index($this->locale));
    }
}
