<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\{Product,City,User,Notification};
use App\Http\Requests\Admin\AddNotificationRequest;
use App\Traits\NotificationTrait;

class NotificationController extends Controller
{
    use NotificationTrait;
    public function __construct()
    {
        $this->model="App\Models\Notification";
        $this->User="App\Models\User";
    }

    public function index(){
        #TODO complete
        $this->lang();
        $notifications=Notification::with(["region:id,$this->locale"])
        ->get();
        return view('admin.notifications.index',compact('notifications'));
    }

    public function create(){
        $this->lang();
        $sellers=[];
        $products=[];
        $regions = City::whereNotNull('parent_id')->get(['id',$this->locale]);
        return view('admin.notifications.add',compact('sellers','products','regions'));
    }

    public function store(AddNotificationRequest $request){
         $data=$request->validated();
        Notification::create($data);
        $notification=
        [
            'type' => "1",
            'title' => $request->name_ar,
            'title_en' => $request->name_en,
            'message' => $request->description_ar,
            'message_en' => $request->description_en,
            'region_id' =>$request->region_id ,

        ];
        $subscribers=[];
        if($request->region_id){
            $subscribers = User::whereCityId($request->region_id)->whereNotNull('device_id')->pluck('device_id');
        }
        $this->sendNotification($data_send=$notification,$subscribers);
        return  to_route('admin.notifications.index')->with('success',trans('lang.created'));
    }

    public function destroy(Request $request){
        Notification::destroy($request->id);
        return  to_route('admin.notifications.index')->with('success',trans('lang.deleted'));
    }


}
