<?php

namespace App\Http\Controllers\Driver\Auth;

use DB;
use Illuminate\Http\Request;
use App\Services\AuthService;
use App\Http\Controllers\Controller;
use App\Models\{User,ConfirmationCode};
use App\Repositories\UserRepositoryInterface;
use App\Traits\{ResponsesTrait,SendSmsTrait};
use App\Http\Requests\Client\CheckPhoneRequest;
use App\Http\Requests\Client\CheckClientExistsRequest;
use App\Http\Requests\Auth\{LoginRequest,RegisterRequest};

class UserAuthController extends Controller
{
    use ResponsesTrait,SendSmsTrait;
    private $userRepository;

    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function checkClientExists(CheckClientExistsRequest $request){
       $user= $this->userRepository->findByPhone($request->phone);
        if($user !=null)
            return $this->failed(null, trans('lang.phoneFound'));
        return $this->success();
    }

    public function register(RegisterRequest $request){
        $data=$request->validated();
        // $data['password']="password";
        $user = User::withTrashed()->Where("phone" , $request->phone)->first();
        if($user && !is_null($user->deleted_at)){
            $data['deleted_at'] = null ;
            $user->update($data);
        }elseif($user){
            return $this->failed(null, trans('lang.phoneFound'));
        }
        else{
            $user = User::create($data);
        }
        $user->token = $user->createToken('API Token')->accessToken;
        return $this->success(["user"=>$user],trans("lang.created"));
    }

    public function login(LoginRequest $request, AuthService $service){
        return $service->login($request);
        // $data['password']=$request->password;
        // $data['phone']=$request->phone;
        
        // if (!auth()->attempt($data)) 
        //     return $this->failed(null,trans('lang.incorrect_details'));
        // $user=auth()->user();
        // $user->token = $user->createToken('API Token')->accessToken;
        // $user->type =1;
        // return $this->success(["user"=>$user]) ;
    }

    public function logout(Request $request)
    {
        if(auth()->user())
        {
            auth()->user()->update(['device_id'=>null]);
            auth()->user()->token()->revoke();
        }
        return $this->success(null,trans('logout_success')) ;
    }

    public function sendOtpRegister(CheckPhoneRequest $request){
        $code   = rand(1111,9999);
        $phone = '2'.$request->phone;
        // return $phone;
        ConfirmationCode::create(["phone" => $phone,"code"=>$code]);
        $this->sendSmsWhatsApp($phone, $code);
        // return "here";
        $data['otpCode'] = $code;
        return $this->success($data);
        // $phone = '+965'.$request->phone;
        // $this->sendSMS($phone, "OTP code is: $code" );
    }



    // public function sendOtpPassword(CheckPhoneExists $request){
    //     $code   = rand(1111,9999);
    //     $phone = '+965'.$request->phone;
    //     $this->sendSMS($phone, "OTP code is: $code" );
    //     $data['otp_code'] = $code;
    //     return $this->success($data);
    // }

    
    // public function sendSMS($phone, $message){
    //     $curl = curl_init();
    //     $obj=json_encode(["src"=> "+14152225555",
    //         "dst"=> $phone,
    //         "text"=> $message,
    //         "type"=> "sms",
    //         "url"=> "https://foo.com/sms status",
    //         "method"=> "POST",
    //         "log"=> "true",
    //         "trackable"=> false
    //     ]);
    //     curl_setopt_array($curl, array(
    //       CURLOPT_URL => 'https://api.plivo.com/v1/Account/MAZGY3ZJC0OTQXNTJMYJ/Message/',
    //       CURLOPT_RETURNTRANSFER => true,
    //       CURLOPT_ENCODING => '',
    //       CURLOPT_MAXREDIRS => 10,
    //       CURLOPT_TIMEOUT => 0,
    //       CURLOPT_FOLLOWLOCATION => true,
    //       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //       CURLOPT_CUSTOMREQUEST => 'POST',
    //       CURLOPT_POSTFIELDS =>$obj,
    //       CURLOPT_HTTPHEADER => array(
    //         'Authorization: Basic TUFaR1kzWkpDME9UUVhOVEpNWUo6Tmpsak9XVTFPRGs0TlRnek56UmlZbUpqWXpVM01XVmpObVZqTmpabQ==',
    //         'Content-Type: application/json'
    //       ),
    //     ));
        
    //     $response = curl_exec($curl);
        
    //     curl_close($curl);
    //     // echo $response;
    // }


}
