<?php

namespace App\Http\Requests\Client;

use Illuminate\Foundation\Http\FormRequest;

class EditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'id' => 'required',
            'active' => 'required',
            'password' => 'sometimes|nullable',

            'subscription_start_date' => 'required|',
            'subscription_end_date' => 'required|after_or_equal:subscription_start_date|after_or_equal:'.date('Y-m-d'),
        ];
    }
    
    public function messages(): array {
        return [
            'id.required'  => 'The id is required',
            'active.required'  => 'The code is cover',
  
            "subscription_end_date.after_or_equal" =>'the end date should be after or equal today',
            
            "subscription_start_date.after_or_equal" =>'the start  date should be after or equal today'
        ];
    }

}
