<?php

namespace App\Models;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RideDriver extends Model
{
    use HasFactory;
    protected $table="ride_driver";
    protected $fillable = [
        'user_id' ,  'client_id' ,   'city_id',
        'total_price','actual_price' ,
        'total_time' ,'actual_time' ,
        'total_distance' ,'actual_distance',
        'total_waiting_time' , 'total_waiting_time_fee' ,
        'status' ,'start_fee' ,'km_fee' ,'waiting_fee',
        'driver_rate' , 'car_rate' , 'client_description'
    ]; 

    // public function setUserIdAttribute()
    // {
    //     $this->attributes['user_id'] =Auth::user()->id;
    // }

    protected $hidden = [
        
    ]; 


    protected $dates =[
        "created_at",
        'updated_at'
       
    ];
    public function user(){
        return $this->belongsTo(User::class);
    }

    public function startPoint(){
        return $this->hasOne(RideDriverDetails::class)->where("is_start_point",1)->select(['ride_driver_id','name','is_start_point']);
    }

    public function endPoints(){
        return $this->hasMany(RideDriverDetails::class)->where("is_end_point",1)->select(['ride_driver_id','name','is_end_point']);
    }
    
    public function serializeDate($date)
    {
        return $date->format('Y-m-d h:i:s'); // Format the date as desired
    }

}
