<?php

namespace App\Services;

use App\Models\RideDriver;
use App\Models\AppConfiguration;
use App\Models\RideDriverDetails;
use Illuminate\Support\Facades\Log;
use App\Repositories\RideRepository;
use App\Http\Resources\RidesResource;
use App\Services\CalculateDistanceService;

class RideService
{
    private $rideRepository,$calculateDistanceService;
    public function __construct(RideRepository $rideRepository,CalculateDistanceService $calculateDistanceService)
    {
        $this->rideRepository = $rideRepository;  
        $this->calculateDistanceService = $calculateDistanceService;  
    }
    
    function rideDetails($request){
     
        $ride =RideDriver::find($request->id);
        return RidesResource::make($ride);
    }

    function startRide($request){
        Log::info("newRide " .json_encode($request->validated()) );
        $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();
        $rideDriver['total_time']=$request->total_time??0;
        $rideDriver['total_distance']=$request->total_distance??0;
        $rideDriver['user_id']=auth()->id();
        $rideDriver['city_id']=auth()->user()->city_id;
        $rideDriver['start_fee']=$appConfiguration->start_fee;
        $rideDriver['km_fee']=$appConfiguration->km_price;
        $rideDriver['waiting_fee']=$appConfiguration->waiting_price;
        // $rideDriver['actual_price']=$appConfiguration->start_fee;
        $rideDriver['total_price']=$request->total_distance *$appConfiguration->km_price;
        $ride=RideDriver::create($rideDriver);
        $rideDriverDetails['ride_driver_id']=$ride->id;
        // foreach(($request->points) as $point){
        foreach(json_decode($request->points,true) as $point){
            $rideDriverDetails['is_start_point']=0;
            $rideDriverDetails['is_end_point']=0;
            $rideDriverDetails['lat']=$point['lat'];
            $rideDriverDetails['lang']=$point['lang'];
            $rideDriverDetails['name']=$point['name'];
            Log::info("order  id " . $point['order']);
            if($point['order'] == "1"){
                $rideDriverDetails['is_start_point']=1;
            }
            else{
                $rideDriverDetails['is_end_point']=1;
            }
            $this->rideRepository->createpoint($rideDriverDetails);
        }
        Log::info("newRide  id" .$ride->id );
        return $ride;
    }

    function editRideLocation($request,$status=false){
        // Log::info("update Ride " .json_encode($request->all()) );

        // $point=($request->points); //json_decode($request->points,true);
        $point =json_decode($request->points,true);
        $rideDriverDetails['ride_driver_id']=$request->id;
        $rideDriverDetails['lat']=$point['lat'];
        $rideDriverDetails['lang']=$point['lang'];

        
        $lastPoint=RideDriverDetails::where('ride_driver_id',$request->id)->orderByDESC('id')->first(['lang','lat','id']);
        Log::info("lastPoint  " .$lastPoint);

        // $calculateDistanceResult=
        // $this->calculateDistanceService->calculateDistance($point['lang'],$point['lat'],$lastPoint->lang,$lastPoint->lat);
        Log::info('new lang '.$point['lang']);
        Log::info('new lat '.$point['lat']);
        Log::info('old lang '.$lastPoint->lang);
        Log::info('old lat '.$lastPoint->lat);
        // Log::info("calculateDistanceResult  id" .json_encode($calculateDistanceResult) );
        $distance= $request->distance;
        // $time= $calculateDistanceResult['time']/60000;

        $ride =RideDriver::find($request->id);
        // $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();

         if($status==true){
            // $km_price=$appConfiguration->km_price;
            $date1 = $ride->created_at;
               $date2 = now();

            $diff = $date2->diff($date1);
            $hoursDifference = $diff->h; // Hours
            $minutesDifference = $diff->i; // Minutes
            // Calculate the difference in minutes
            $date=($hoursDifference*60)+$minutesDifference;
        //   return $date;
            $updated=[
                'status'=>1,'actual_distance'=>$ride->actual_distance+$distance,
                'actual_price'=>($ride->actual_distance+$distance)*($ride->km_fee/1000),
                'total_waiting_time_fee'=>$request->speed * $ride->waiting_fee,
                'actual_time' =>$date
                // ,'total_waiting_time' =>$request->speed
            ];
        }else{
            $updated=[
                'actual_distance'=>$ride->actual_distance+$distance,
                'total_waiting_time_fee'=>$request->speed * $ride->waiting_fee,
                'total_waiting_time' =>$request->speed
            ];
        }
        
        $ride->update($updated);

        // Log::info("ride  " .$ride);
        Log::info("edit distance  " .$distance);
        // Log::info("edit time  " .$time);
        // Log::info("edit id  " .$request->id);

        $this->rideRepository->createpoint($rideDriverDetails);
        //  $ride->km_price=$appConfiguration->km_price;
        // $ride->waiting_price=$appConfiguration->waiting_price;
        return RidesResource::make($ride);
        // return $ride;
    }

    function finishRide($request){
        $ride=$this->editRideLocation($request,true);
        return $ride;
    }

}