<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class StatisticsController extends Controller
{
    
    public function __construct()
    {
        $this->model="App\Models\Consultation";
        $this->City="App\Models\City";
        $this->User="App\Models\User";
        $this->RideDriver="App\Models\RideDriver";
    }

     public function report1(Request $request){
        $this->lang();
        $totalRides=$this->RideDriver::count();
        $drivers=$this->User::select('id','name')->get();
        $cities = $this->City::whereNotNull('parent_id')->select('id',$this->locale)->get();
        $searchResultRides=$this->RideDriver::query()
        ->select('id','city_id','user_id','actual_price');
        $conditions=[];
        if($request->city_id){
            $conditions['city_id']=$request->city_id;
        }
        if($request->driver_id){
            $conditions['user_id']=$request->driver_id;
        }
        if($conditions){
            $searchResultRides=$searchResultRides->where($conditions);
        }
        $searchResultRides=$searchResultRides->get();
        $searchResultRidesCount=$searchResultRides->count();
        $searchResultRidesIncome=number_format($searchResultRides->sum('actual_price'),2);
        return view('admin.reports.report1',compact('totalRides','drivers','cities','searchResultRidesCount','searchResultRidesIncome'));

     }
    public function index(Request $request){
        // $gender=$request->gender;

        // $section_id=$request->section_id;

        // $totalConsultations=$this->model::count();

        // $sections=$this->Section::withCount('consultations')->get();

        // $countries=$this->Country::get(['id','name']);

        // $searchResult=$this->model::where('country_id',$request->country_id);

        // $searchResult->when($section_id, function ($query, $section_id) {
        //     return $query->where('section_id',$section_id);
        // })
        // ->when($gender, function ($query, $gender) {
        //     return $query->whereHas('userInfo', function ($q) use ($gender){
        //         $q->where('gender',$gender);
        //     });
        // });
        
        // $searchResult=$searchResult->count();
        return view('admin.home');
    }
}
