<?php

namespace App\Http\Controllers\Client\Auth;

use App\Models\Client;
use App\Models\ContactUs;
use Illuminate\Http\Request;
use App\Models\ConfirmationCode;
use App\Traits\{ResponsesTrait};
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\Client\Auth\RegisterRequest;
use App\Http\Requests\Client\ContactUs\StoreRequest;

class UserAuthController extends Controller
{
    use ResponsesTrait;
    public function test(){

        // if (false == Auth::guard('api-clients')->check()) {
        //     return"now";
        //     }
        return auth()->guard("client")->user();
    }

    public function login(Request $request)
    {
        $credentials = request(['phone', 'password']);

        // if (!auth()->guard("api-clients")->attempt($credentials)) {
        //     return $this->failed(null,trans('lang.incorrect_details'));
        // }
        $client = Client::where('phone', $request->phone)->first();
        if(!isset($client)){
            return $this->failed(null,trans("lang.account_Not_found"));
        }

        if (!Hash::check(request('password'), $client->password)) {
            return $this->failed(null,trans('lang.Incorrect_password'));
        } 
        if($client->active !=1)
            return $this->failed(null,trans('lang.not_active'));
       

            $token = $client->createToken('ClientToken')->accessToken;

            // Append the generated token to the client object
            $client->token = $token;

        return $this->success( $client);
    }

    public function logout(Request $request)
    {
        if(auth()->user())
        {
            auth()->user()->update(['device_id'=>null]);
            auth()->guard("client")->user()->token()->revoke();
        }
        return $this->success(null,trans('logout_success')) ;
    }

    public function register(RegisterRequest $request){
    
        $data=$request->validated();
        $obj=ConfirmationCode::where("phone","2".$request->phone)->latest('created_at')->first();
        if($obj ==null||$obj->code!=$request->otpCode ){
            return $this->failed(null, "Wrong otp");
        }
        // $data['password']="password";
        $client = Client::create($data);
        $client->token = $client->createToken('ClientToken')->accessToken;
        return $this->success(["user"=>$client],trans("lang.created"));
    }

    public function checkClientExists(Request $request){
        $user=  Client::where('phone', $request->phone)->first()??null;
         if($user !=null)
             return $this->failed(null, trans('lang.phoneFound'));
         return $this->success();
    }

     public function contactUs(StoreRequest $request){
        $data=$request->validated();
        $data['user_id']=auth()->id();
        $data['type']="client";
        ContactUs::create($data);
        return $this->success(null,trans('lang.created'));
    }
    
}
