<?php

namespace App\Http\Controllers\Client;

use App\Models\RideDriver;
use Illuminate\Http\Request;
use App\Services\RideService;
use App\Traits\{ResponsesTrait};
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\Ride\Rate\StoreRequest;
use App\Http\Requests\Client\Ride\StoreRequest as RideStoreRequest;
use App\Repositories\RideRepository;

class RideController extends Controller
{
    use ResponsesTrait;
    private $rideRepository,$rideService,$calculateDistanceService;
    public function __construct(RideRepository $rideRepository, RideService $rideService)
    {
        $this->rideRepository = $rideRepository;  
        $this->rideService = $rideService;  
    }
    function index(){
        $rides=RideDriver::whereClientId(auth()->guard("client")->user()->id)
        ->with(["endPoints",'startPoint'])
        ->select('id','created_at','actual_price','actual_distance')
        ->get();
        return $this->success(["rides"=>$rides,"total_rides"=>$rides->count(),"total_actual_price" =>number_format($rides->sum('actual_price'),2) ]);
    }
    
    function details(Request $request){
        $rides=RideDriver::whereUserId(auth()->id())->first();
      return $this->success($this->rideService->rideDetails($request));
    }


    
    function startRide(RideStoreRequest $request){
        Log::info("startRide" );
        $ride=$this->rideService->clientStartRide($request);
        return $this->success(['id'=>$ride->id],trans('lang.created'));
        // CalculateDistance::dispatch();
        // return $this->success(null,trans('lang.updated'));
    }

    public function rate(StoreRequest $request){
        RideDriver::whereId($request->id)->update($request->validated());
        return $this->success(null,trans('lang.updated'));
    }

    function editRideLocation(Request $request){
        Log::info("client_editRideLocation" );
        $ride=$this->rideService->editRideLocation($request);
        return $this->success($ride,trans('lang.updated'));
    }

    function cancelRide(Request $request){
        Log::info("cancelRide" );
        $this->rideService->cancelRide($request);
        return $this->success(null,trans('lang.cancelled'));
    }

}
