<?php

namespace App\Http\Controllers\Driver;
use App\Services\UserService;
use App\Traits\ResponsesTrait;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\EditProfileRequest;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\RideDriver;

class ProfileController extends Controller
{
    use ResponsesTrait;
    private $userRepository;
    private $userService;
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;  
    }

    function indexWeb(Request $request){
        // return $request->all();
        $user=User::find($request->id);
        if($user){
                  $ride=RideDriver::where(['user_id'=>$user->id,'status'=>'0'])->first();
                if($ride){
                        return view('profile',compact('ride'));
                }else{
                        return view('profile',compact('user'));
            }
          
        }
       
    }
    function index(){
        return $this->success( $this->userService->findCurrentUser());
    }

    function update(EditProfileRequest $request){
        Log::info("update profile" );
        $user= $this->userService->updateCurrentUser($request->validated());
        return $this->success($user,trans('lang.updated'));
    }
    
    function updateLang(Request $request){
        Log::info("update lang" );
        // auth()->user()->update(['lang'=>$request->lang]);
        return $this->success(null,trans('lang.updated'));
    }
    
    function updateLocation(Request $request){
        Log::info("updateLocation" );
        auth()->user()->update(['lang'=>$request->lang,'lat'=>$request->lat]);
        return $this->success(null,trans('lang.updated'));
    }
    
      function updateStatus(Request $request){

        Log::info("update updateStatus" );
        $user=auth()->user();
        $user=auth()->user()->update(['is_online'=>!$user->is_online]);
        return $this->success(auth()->user(),trans('lang.updated'));
    }
    
    
    public function destroy(){
        $this->userService->deleteCurrentUser();
        return $this->success(null,trans('lang.deleted'));
    }
}
