<?php

namespace App\Http\Requests\Admin\CarModel;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name_ar' => "required|unique:car_models,name_ar",
            'name_en' => "required|unique:car_models,name_en"
        ];
    }

    public function messages(): array {
        return [
            'name_ar.unique'  => 'This name already used.',
            'name_en.unique'  => 'This name already used.',
        ];
    }
}
