<?php

namespace App\Http\Requests\Admin\City;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'parent_id' => 'sometimes|nullable',
            'name_ar' => 'required|unique:cities,name_ar',
            'name_en' => 'required|unique:cities,name_en',
        ];
    }
    
    public function messages(): array {
        return [
             'name_ar.unique' => "تم انشاء هذا الاسم باللغة العربية من قبل",
             'name_en.unique' => "تم انشاء هذا الاسم باللغة الانجليزية  من قبل",
        ];
    }
}
