<?php

namespace App\Repositories;

use App\Models\User;

class UserRepository implements UserRepositoryInterface
{
    public function findCurrentUser()
    {
        return  auth()->user()??null;
    }

    public function findByPhone($phone)
    {
        return  User::where('phone', $phone)->first()??null;
    }

    public function updateCurrentUser($data)
    {
        $user =auth()->user();
        $user->update($data);
        return $user;
    }

    public function deleteCurrentUser()
    {
        auth()->user()->delete();
    }

    
}