<?php

namespace App\Services;

use App\Models\User;
use App\Models\Client;
use App\Models\RideDriver;
use App\Models\AppConfiguration;
use App\Models\RideDriverDetails;
use Illuminate\Support\Facades\Log;
use App\Repositories\RideRepository;
use App\Http\Resources\RidesResource;
use App\Services\CalculateDistanceService;
use App\Traits\NotificationTrait;

class RideService
{
    use NotificationTrait;
    private $rideRepository,$calculateDistanceService;
    public function __construct(RideRepository $rideRepository,CalculateDistanceService $calculateDistanceService)
    {
        $this->rideRepository = $rideRepository;  
        $this->calculateDistanceService = $calculateDistanceService;  
    }
    
    function rideDetails($request){
     
        $ride =RideDriver::find($request->id);
        return RidesResource::make($ride);
    }

    function startRide($request){
        Log::info("newRide " .json_encode($request->validated()) );
        $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();
        $usedPrice=($request->vechile_type=='moto')?$appConfiguration->moto_km_price:$appConfiguration->km_price;
        $rideDriver['total_time']=$request->total_time??0;
        $rideDriver['total_distance']=$request->total_distance??0;
        $rideDriver['user_id']=auth()->id();
        $rideDriver['city_id']=auth()->user()->city_id;
        $rideDriver['start_fee']=$appConfiguration->start_fee;
        $rideDriver['km_fee']=$usedPrice;
        $rideDriver['waiting_fee']=$appConfiguration->waiting_price;
        // $rideDriver['actual_price']=$appConfiguration->start_fee;
        $rideDriver['total_price']=$request->total_distance *$usedPrice;
        $ride=RideDriver::create($rideDriver);
        $rideDriverDetails['ride_driver_id']=$ride->id;
        // foreach(($request->points) as $point){
        foreach(json_decode($request->points,true) as $point){
            $rideDriverDetails['is_start_point']=0;
            $rideDriverDetails['is_end_point']=0;
            $rideDriverDetails['lat']=$point['lat'];
            $rideDriverDetails['lang']=$point['lang'];
            $rideDriverDetails['name']=$point['name'];
            Log::info("order  id " . $point['order']);
            if($point['order'] == "1"){
                $rideDriverDetails['is_start_point']=1;
            }
            else{
                $rideDriverDetails['is_end_point']=1;
            }
            $this->rideRepository->createpoint($rideDriverDetails);
        }
        Log::info("newRide  id" .$ride->id );
        return $ride;
    }

    function clientStartRide($request){
        Log::info("newRide " .json_encode($request->validated()) );
        // $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();
        $rideDriver['total_time']=$request->total_time??0;
        $rideDriver['total_distance']=$request->total_distance??0;
        $rideDriver['client_id']=auth()->guard("client")->user()->id;
        // $rideDriver['city_id']=auth()->user()->city_id;
        // $rideDriver['start_fee']=$appConfiguration->start_fee;
        // $rideDriver['km_fee']=$appConfiguration->km_price;
        // $rideDriver['waiting_fee']=$appConfiguration->waiting_price;
        // $rideDriver['actual_price']=$appConfiguration->start_fee;
        // $rideDriver['total_price']=$request->total_distance *$appConfiguration->km_price;
        $ride=RideDriver::create($rideDriver);
        $rideDriverDetails['ride_driver_id']=$ride->id;
        // foreach(($request->points) as $point){
        
        foreach(json_decode($request->points,true) as $point){
            $rideDriverDetails['is_start_point']=0;
            $rideDriverDetails['is_end_point']=0;
            $rideDriverDetails['lat']=$point['lat'];
            $rideDriverDetails['lang']=$point['lang'];
            $rideDriverDetails['name']=$point['name'];
            Log::info("order  id " . $point['order']);
            if($point['order'] == "1"){
                $rideDriverDetails['is_start_point']=1;
                $lat=$point['lat'];
                $lang=$point['lang'];
            }
            else{
                $rideDriverDetails['is_end_point']=1;
            }
            $this->rideRepository->createpoint($rideDriverDetails);
        }
        Log::info("client newRide  id" .$ride->id );
        
        $notification=
        [
            'type' => "2",
            'title' => "رحلة جديدة",
            'title_en' => "New ride request",
            'message' => " طلب رحلة جديدة",
            'message_en' => "New ride request",
            "ride_id" =>$ride->id
        ];
        
        
        $subscribers=$this->getNearestDrivers($lat,$lang,5,$request->vechile_type,$request->gender);
          Log::info("drivers " .json_encode($subscribers) );

        $this->sendNotification($data_send=$notification,$subscribers);
        return $ride;
    }
    
    function getNearestDrivers($latitude, $longitude, $radius,$vechile_type,$gender) {
        
        $cond=["is_online"=>1];
        if($vechile_type){
            $cond['vechile_type']=$vechile_type;
        }
        if($gender){
            $cond['gender']=$gender;
        }
        $nearestDrivers = User::where(['is_online' => 1])
        ->select('device_id')
        ->selectRaw('( 6371 * acos( cos( radians(?) ) *
                       cos( radians( lat ) )
                       * cos( radians( lang ) - radians(?)
                       ) + sin( radians(?) ) *
                       sin( radians( lat ) ) )
                     ) AS distance', [$latitude, $longitude, $latitude])
        ->having('distance', '<=', $radius)
        ->orderBy('distance')
        ->pluck('device_id');
    
        return $nearestDrivers;
    }


    function editRideLocation($request,$status=false){
        Log::info("update Ride " .json_encode($request->all()) );

        // $point=($request->points); //json_decode($request->points,true);
        $point =json_decode($request->points,true);
        $rideDriverDetails['ride_driver_id']=$request->id;
        $rideDriverDetails['lat']=$point['lat'];
        $rideDriverDetails['lang']=$point['lang'];

        $lastPoint=RideDriverDetails::where('ride_driver_id',$request->id)
        ->orderByDESC('id')
        ->first(['lang','lat','id']);
        Log::info("lastPoint  " .$lastPoint);

        // $calculateDistanceResult=
        // $this->calculateDistanceService->calculateDistance($point['lang'],$point['lat'],$lastPoint->lang,$lastPoint->lat);
        Log::info('new lang '.$point['lang']);
        Log::info('new lat '.$point['lat']);
        Log::info('old lang '.$lastPoint->lang);
        Log::info('old lat '.$lastPoint->lat);
        // Log::info("calculateDistanceResult  id" .json_encode($calculateDistanceResult) );
        $distance= $request->distance;
        // $time= $calculateDistanceResult['time']/60000;

        $ride =RideDriver::find($request->id);
        // $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();
        if($ride->user_id){
            User::whereId($ride->user_id)->update(['lang'=>$point['lang'],'lat'=>$point['lat']]);
        }
        if($ride->client_id){
            Client::whereId($ride->client_id)->update(['lang'=>$point['lang'],'lat'=>$point['lat']]);
        }
         if($status==true){
            // $km_price=$appConfiguration->km_price;
            $date1 = $ride->created_at;
               $date2 = now();

            $diff = $date2->diff($date1);
            $hoursDifference = $diff->h; // Hours
            $minutesDifference = $diff->i; // Minutes
            // Calculate the difference in minutes
            $date=($hoursDifference*60)+$minutesDifference;
        //   return $date;
            $updated=[
                'status'=>RideDriver::finsih,
                'actual_distance'=>$ride->actual_distance+$distance,
                'actual_price'=>($ride->actual_distance+$distance)*($ride->km_fee/1000),
                'total_waiting_time_fee'=>$request->speed * $ride->waiting_fee,
                'actual_time' =>$date
                // ,'total_waiting_time' =>$request->speed
            ];
        }else{
            $updated=[
                'actual_distance'=>$ride->actual_distance+$distance,
                'total_waiting_time_fee'=>$request->speed * $ride->waiting_fee,
                'total_waiting_time' =>$request->speed
            ];
        }
        
        $ride->update($updated);

        // Log::info("ride  " .$ride);
        Log::info("edit distance  " .$distance);
        // Log::info("edit time  " .$time);
        // Log::info("edit id  " .$request->id);

        $this->rideRepository->createpoint($rideDriverDetails);
        //  $ride->km_price=$appConfiguration->km_price;
        // $ride->waiting_price=$appConfiguration->waiting_price;
        $ride=$ride->load("user:id,name,phone,image");
        return RidesResource::make($ride);
        // return $ride;
    }

    function finishRide($request){
        $ride=$this->editRideLocation($request,true);
        return $ride;
    }

    function cancelRide($request){
        RideDriver::whereId($request->id)->update(["status"=>RideDriver::cancelled]);
    }

    function initalAcceptRide($request){
        $ride =RideDriver::find($request->id);
        $data['status']=RideDriver::acceptNotDelivered;
        $data['user_id']=auth()->id();
        $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->first();
        $usedPrice=(auth()->user()->vechile_type=='moto')?$appConfiguration->moto_km_price:$appConfiguration->km_price;
        $rideDriver['city_id']=auth()->user()->city_id;
        $rideDriver['start_fee']=$appConfiguration->start_fee;
        $rideDriver['km_fee']=$usedPrice;
        $rideDriver['waiting_fee']=$appConfiguration->waiting_price;
        $rideDriver['actual_price']=$appConfiguration->start_fee;
        $rideDriver['total_price']=$ride->total_distance *$usedPrice;
        $rideDetails=RideDriverDetails::where(['ride_driver_id'=>$request->id,'is_start_point'=>1])->first();
        $ride->update($data);
        $route['fLat']=auth()->user()->lat;
        $route['fLang']=auth()->user()->lang;
        $route['sLat']=$rideDetails->lat;
        $route['sLang']=$rideDetails->lang;
        $result=$this->graphHopperRoute($route);
        $client=Client::find($ride->client_id);
        $result['client_name']=$client->name;
        $result['client_phone']=$client->phone;
        return $result;
    }
    
    function graphHopperRoute($data){
        $fLat=$data['fLat'];
        $fLang=$data['fLang'];
        $sLat=$data['sLat'];
        $sLang=$data['sLang'];
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://graphhopper.com/api/1/route?point=$fLat,$fLang&point=$sLat,$sLang&profile=car&locale=de&key=f57ce6e2-7333-45d7-9e25-80a0a8d63665&points_encoded=false",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Accept: application/json'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        $response = json_decode($response, true);
        return ["distance"=>$response['paths'][0]['distance']/1000,
        "time"=>$response['paths'][0]['time']/60000];
    }
    
    
    function deliveredRide($request){
        $ride =RideDriver::find($request->id);
        $data['status']=RideDriver::acceptDelivered;
        $ride->update($data);
        $rideDetails=$ride->load('endPointsDetails');
        return  $rideDetails->endPointsDetails;
    }


}