@if(isset($ride))

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" href="{{asset('assets/images/logo/logo.png')}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{asset('assets/images/logo/logo.png')}}" type="image/x-icon">
    <title>Driver Ride Information</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background-color: #FEDE00;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .ride-info {
            width: 300px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }
        .ride-info h2 {
            margin-top: 0;
        }
        .ride-info p {
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="ride-info">
        <h2>Driver Ride Information</h2>
        <p>Total Waiting Time Fee: ${{$ride->total_waiting_time_fee}}</p>
        <p>Start Fee: EGP{{$ride->start_fee}}</p>
        <p>Actual Distance: {{$ride->actual_distance}} KM</p>
        <p>Actual Price: EGP{{$ride->actual_price}}</p>
    </div>
</body>
</html>

@else
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" href="{{asset('assets/images/logo/logo.png')}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{asset('assets/images/logo/logo.png')}}" type="image/x-icon">
    <title>Driver Information</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background-color: #FEDE00;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh; /* Ensure the page takes at least the full viewport height */
        }
        .driver-info {
            width: 300px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .driver-info img {
            max-width: 100%;
            border-radius: 50%;
        }
        .driver-info h2 {
            margin-top: 10px;
        }
        .driver-info p {
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="driver-info">
         <img src="{{asset($user->image)}}" alt="Driver Image">
        <h2>{{$user->name}}</h2>
        <p>Phone: {{$user->phone}}</p>
        <p>Birth Date: {{$user->birth_date->format('Y-m-d')}}</p>
        <p>Model Year: {{$user->model_year}}</p>
    </div>
    
</body>
</html>

@endif
