<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Route;

Route::post('login', [Client\Auth\UserAuthController::class, 'login'])->name('login');
Route::post('register', [Client\Auth\UserAuthController::class, 'register'])->name('register');
Route::post('check_client_exists', [Client\Auth\UserAuthController::class, 'checkClientExists']);
Route::post('reset_password', [Client\Auth\ResetPasswordController::class, 'resetPassword']);

Route::middleware(['auth:client'])->group(function () {
    // Route::get('logout', [Driver\Auth\LoginController::class, 'logout'])->name('logout');
    Route::get('logout', [Client\Auth\UserAuthController::class, 'logout'])->name('logout');
    Route::post('updateLang', [Client\ProfileController::class, 'updateLang']);
    Route::post('edit_password', [Client\Auth\ResetPasswordController::class, 'editPassword']);

    #profile
    Route::get('profile', [Client\ProfileController::class, 'profile'])->name('profile');
    Route::post('profile', [Client\ProfileController::class, 'update']);
    Route::delete('profile', [Client\ProfileController::class, 'destroy']);

    #rate
    Route::post('rate', [Client\RideController::class, 'rate']);
    Route::post('rides', [Client\RideController::class, 'index']);
    Route::post('ride', [Client\RideController::class, 'details']);

    Route::post('start-ride', [Client\RideController::class, 'startRide']);
    Route::post('cancel-ride', [Client\RideController::class, 'cancelRide']);
    Route::post('update-ride-info', [Client\RideController::class, 'editRideLocation']);




    Route::post('contactUs', [Client\Auth\UserAuthController::class, 'contactUs'])->name('contactUs');

    Route::get('test', [Client\Auth\UserAuthController::class, 'test'])->name('test');

    // //Profile
    // Route::get('profile', [Driver\ProfileController::class, 'index']);
    // Route::post('edit_profile', [Driver\ProfileController::class, 'update']);

    // //Orders

    // Route::get('orders', [Driver\OrderController::class, 'index']);
    // Route::get('order_details', [Driver\OrderController::class, 'details']);
    // Route::post('order_delivery', [Driver\OrderController::class, 'orderDelivery']);
    
});