<?php

namespace App\Http\Controllers\Admin;

use App\Models\AboutUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\EditSettingRequest;
use App\Traits\FileUploadTrait;

class AboutUsController extends Controller
{
    use FileUploadTrait;
    public function edit(){
        $settings=AboutUs::find(1);
        return view('admin.settings.edit',compact('settings'));
    }
    
   
    public function update(EditSettingRequest $request){
        $data=$request->validated();
        $setting=AboutUs::find(1);
        
        $img_name = $setting->home_images;
        if ($request->hasFile('home_images')) {

            //delete old pictures
            if ($img_name != "") {
                $pictures = explode(',', $img_name);
                foreach ($pictures as $pic) {
                    $folder_path = public_path($pic);
                    @unlink($folder_path);
                }
            }

            // add new pictures
            $gallery = [];
            foreach ($request->file('home_images') as $pic) {
                $img_name = $this->uploadFile($pic, 'page');
                array_push($gallery, $img_name);
            }
            $img_name = implode(',', $gallery);
            $data['home_images'] =$img_name;
        }
        
        
        $setting->update($data);
        return back()->with('success',trans('lang.updated'));
    }
}
