<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;


class CommentController extends Controller
{
    use ResponsesTrait;
    public function __construct()
    {
        $this->model="App\Models\Comment";
        $this->post="App\Models\Info";
    }
    
    public function index(GetRequest $request){
        $comments=$this->model::where('post_id',$request->post_id)
        ->with('userInfo:id,name,image')
        ->get();
        return $this->success($comments);
    }
    

    
    public function destroy(CheckRequest $request){
        $this->model::destroy($request->id);
        return $this->success(trans('lang.deleted'));    
    }


}
