<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class EvaluationController extends Controller
{
    public function __construct()
    {
        $this->model="App\Models\Consultation";
    }

    public function index(){
          $evaluations=$this->model::where('is_published','>',0)->orderByDESC('id')->get();
         
         $evaluations=  $evaluations->load(['consultantInfo','userInfo','section']);
        return  view('admin.evaluations.index',compact('evaluations'));
    }

    public function accept($id){
        $this->model::whereId($id)->update(['is_published'=>2]);
        return redirect(route('admin.evaluations.index'))->with('success',trans('lang.updated'));
    }

    public function refuse($id){
        $this->model::whereId($id)->update(['is_published'=>3]);
        return to_route('admin.evaluations.index')->with('success',trans('lang.updated'));
    }
}
