<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\Sections\EditSectionRequest;
use App\Http\Requests\Info\StoreRequest;
use App\Http\Requests\Info\EditRequest;
use App\Traits\FileUploadTrait;
use Illuminate\Support\Facades\File;

class InfoController extends Controller
{
    use FileUploadTrait;
    public function __construct()
    {
        $this->model="App\Models\Info";
        $this->consultant="App\Models\Consultant";
        $this->Comment="App\Models\Comment";
    }

    public function index(){
        $info=$this->model::get();
        return view('admin.info.index',compact('info'));
    }

    public function comments($id){
        $comments=$this->Comment::wherePostId($id)
        ->with('userInfo:id,name')
        ->get();
        return view('admin.comment.index',compact('comments'));
    }
    
    public function deleteComment(Request $request){
        $this->Comment::destroy($request->id);
        return back()->with('success',trans('lang.deleted'));

    }
    
    public function create (){
        $consultants = $this->consultant::consultant()->get();
        return view('admin.info.add',compact('consultants'));
    }
    public function store(StoreRequest $request){
        $data=$request->validated();
        if(isset($_FILES['link'])) {
            $mime = $_FILES['link']['type'];
            if(strstr($mime, "video/")){
                $filetype = "video";
                $filetype = "image";
                $data['type']=2;
            }else if(strstr($mime, "image/")){
                $filetype = "image";
                $data['type']=1;
            }
        }
        $data['link']=$img_name = $this->uploadFile($request->link, 'sections');     
        $data['cover'] = $this->uploadFile($request->cover, 'sections');     
        $this->model::create($data);
        return redirect(route('info.index'))->with('success',trans('lang.created'));
    }

    public function update(EditRequest $request){
        $data=$request->validated();
        $section= $this->model::find($request->id);

        if($request->hasFile('link')) {
            
            if($section->link)
            {
                $img =public_path($section->link);
                File::delete($img);
            }
            $mime = $_FILES['link']['type'];
            if(strstr($mime, "video/")){
                $filetype = "video";
                $filetype = "image";
                $data['type']=2;
            }else if(strstr($mime, "image/")){
                $filetype = "image";
                $data['type']=1;
            }
            
            $data['link']=$img_name = $this->uploadFile($request->link, 'sections');     

        }
        $section->update($data);
        
        return back()->with('success',trans('lang.updated'));
    }
    
    public function destroy(Request $request){
        $info= $this->model::find($request->id);
        if($info->link)
        {
            $img =public_path($info->link);
            $img2 =public_path($info->cover);
            File::delete($img);
            File::delete($img2);
        }
        $info->delete();
      
        return back()->with('success',trans('lang.deleted'));
    }

}
